<?php
function generateBreadcrumbs($links, $currentIndex) {
    // Главная страница — ничего не выводим
    if ($currentIndex === null || $currentIndex === false || $links[$currentIndex]['Level'] == 1) {
        return '';
    }

    $items = [];
    $position = 1;

    // Главная
    $items[] = breadcrumbItem('/', 'Главная', $position++);

    $currentLink = $links[$currentIndex];
    $currentName = $currentLink['Anchor'];
    $currentPage = $currentLink['Page'];
    $currentLevel = $currentLink['Level'];

    // Если Level 2 → только текущая
    if ($currentLevel == 2) {
        $items[] = breadcrumbCurrent($currentName);
    }

    // Если Level 3 → ищем ближайший выше Level 2
    if ($currentLevel == 3) {
        for ($i = $currentIndex - 1; $i >= 0; $i--) {
            if ($links[$i]['Level'] == 2) {
                $parentName = $links[$i]['Anchor'];
                $parentPage = $links[$i]['Page'];
                $items[] = breadcrumbItem($parentPage, $parentName, $position++);
                break;
            }
        }
        $items[] = breadcrumbCurrent($currentName);
    }

    return '<div class="breadcrumbs" itemscope itemtype="https://schema.org/BreadcrumbList">'
        . implode(' / ', $items) .
        '</div>';
}

function breadcrumbItem($href, $name, $position) {
    $url = $href === '/' ? '/' : '/' . ltrim($href, '/') . '/';
    return '<span itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">'
        . '<a href="' . $url . '" itemprop="item"><span itemprop="name">' . htmlspecialchars($name) . '</span></a>'
        . '<meta itemprop="position" content="' . $position . '" />'
        . '</span>';
}

function breadcrumbCurrent($name) {
    return '<span>' . htmlspecialchars($name) . '</span>';
}
